/*---------------------------------------------------------------------------+
| PMSPY - Group Message Filter Dialog Procedure
|
| Change History:
| ---------------
| $C1=1.03,06/20/89,smd,creation
| $C2=1.12,06/30/89,smd,GROUP maintenance
| $C3=1.12,06/30/89,smd,change HIGHTLIGHT from checkbox to edit field
| $C4=2.00,08/04/89,smd,change group checkboxes to listbox
|
+---------------------------------------------------------------------------*/

#include "pmspy.h"

static HELP_DATA    helpGroup     = {                      /* HELP dialog data */
                                      { NULL,
                                        IDT_HELP,
                                        IDT_GRP_HELP,      /* HELP resource */
                                      },

                                      IDS_HELP_TITLE_GROUP /* Title */
                                    };

 /***************************************************************************************
  *
  *                       Entry
  *
  ***************************************************************************************/

 MRESULT EXPENTRY GroupDlgProc(          HWND    hwnd,
                                register USHORT  message,
                                         MPARAM  lParam1,
                                         MPARAM  lParam2 )

  {

   /***********************************************************************************
    *
    *                   Local Variables
    *
    ***********************************************************************************/

     ULONG              retcode;
     CHAR               ListText[200];
              PGRP_ITEM pGrp;
     register USHORT    list_index,
                        pbSelected;

 /***************************************************************************************
  *
  *  Process the message
  *
  ***************************************************************************************/

    switch (message)                                    /* Switch off of the message ID */
      {

        case WM_COMMAND:

          switch( pbSelected = LOUSHORT( lParam1 ) )
          {
              case ID_GRP_PB_EXCLUDE:
              case ID_GRP_PB_DELETE:
              case ID_GRP_PB_INCLUDE:

              {
                register MSG_COLOR color = GetColor( hwnd );

                USHORT             curItem,    /* current list item */
                                   nSelected;  /* Number of items selected */

                for(/* Initialize */ nSelected = 0,                    /* Zero out vars                */
                                     curItem   = (USHORT)
                                                 WinSendDlgItemMsg(    /* Query 1st selection          */
                                                 hwnd,                 /*   Dialog handle              */
                                                 ID_GRP_LB_GROUPS,     /*   Listbox ID                 */
                                                 LM_QUERYSELECTION,    /*   Query ID of selected       */
                                                 (MPARAM)LIT_FIRST,
                                                 (MPARAM)NULL);

                    /* Terminate  */ curItem != LIT_NONE;

                    /* Iterate    */ nSelected++,
                                     curItem   = (USHORT)
                                                 WinSendDlgItemMsg(    /* Query next selection         */
                                                 hwnd,                 /*   Dialog handle              */
                                                 ID_GRP_LB_GROUPS,     /*   Listbox ID                 */
                                                 LM_QUERYSELECTION,    /*   Query ID of selected       */
                                                 (MPARAM)curItem,
                                                 (MPARAM)NULL)
                   )
                {
                  pGrp = (PGRP_ITEM)
                         WinSendDlgItemMsg( hwnd,
                                            ID_GRP_LB_GROUPS,
                                            LM_QUERYITEMHANDLE, /*   Message                    */
                                            (MPARAM) curItem,   /*   Item to get handle of      */
                                            (MPARAM) NULL);     /*   Reserved                   */

                  switch( pbSelected )
                  {
                    case ID_GRP_PB_DELETE:
                         DeleteGroup(pSpyData, pGrp->GroupID);
                         break;

                    case ID_GRP_PB_EXCLUDE:
                         IncludeGroup(pSpyData, pGrp, FALSE, color);
                         break;

                    case ID_GRP_PB_INCLUDE:
                         IncludeGroup(pSpyData, pGrp, TRUE, color);
                         break;
                  }
                }

                if (nSelected == 0)  /* Selections? */
                {
                  WinAlarm(HWND_DESKTOP, WA_ERROR);

                  break;                                   /* DO NOT end dialog */
                }
              }

              /*********************************
              *** FALL THROUGH TO END DIALOG ***
              *********************************/

              /**************************************************************************
               *
               *  User cancelled exclusion/inclusion
               *
               **************************************************************************/

              case DID_CANCEL:                          /* CANCEL was selected          */

                  WinDismissDlg( hwnd,                  /* Close dialog */
                                 NULL );                /* WinDlgBox return */

                break;                                  /* Break DID_CANCEL             */

              /**************************************************************************
               *
               *  User asked for HELP
               *
               **************************************************************************/

              case ID_GRP_PB_HELP:

                   WinDlgBox(HWND_DESKTOP, hwnd,
                            (PFNWP)HelpWindowProc,
                             NULL, IDD_HELP, (PVOID)&helpGroup);
                break;
          }

            retcode = NULL;                             /* retcode for any WM_COMMAND   */
            break;                                      /* Break WM_COMMAND             */

        /********************************************************************************/
        /**                                                                            **/
        /** WM_CLOSE:                                                                  **/
        /** - Call WinDismissDlg to close the dialog box                               **/
        /**                                                                            **/
        /********************************************************************************/

        case WM_CLOSE:                                  /* Close Dialog Box.            */

          WinDismissDlg( hwnd, NULL);

          retcode = TRUE;

          break;                                                                           /* DB  @P4A */

        /*******************************************************************************
         *
         *  WM_INITDLG:
         *  - Init pointer to data pointed to by WinDlgBox
         *  - Init global handle of this dlg
         *
         ********************************************************************************/

        case WM_INITDLG:

          /******************************************************************************
          *
          *   Add all Groups to list box
          *
          ******************************************************************************/

          for(/* Initialize */ pGrp = ProcessFirstGroup(pSpyData); /* @ 1st GROUP */
              /* Terminate  */ pGrp != NULL;                       /* @ end of list */
              /* Iterate    */ pGrp = ProcessNextGroup(pSpyData)   /* try next GROUP */
             )
          {
            sprintf(ListText,
                    pGrp->Include ? Strings[IDS_FMT_GRP_INCLUDED]
                                  : Strings[IDS_FMT_GRP_EXCLUDED],
                    pGrp->pDesc       /* Group's mnemonic */
                   );

            list_index = (USHORT) WinSendDlgItemMsg(      /* Send a message to the list   */
                          hwnd,                           /*   Window Handle              */
                          ID_GRP_LB_GROUPS,
                          LM_INSERTITEM,                  /*   Insert item                */
                          (MPARAM) LIT_SORTASCENDING,     /*   Sort                       */
                          (MPARAM) ListText);             /*   Text                       */

            WinSendDlgItemMsg(                            /* Send a message to the list   */
                          hwnd,                           /*   Window Handle              */
                          ID_GRP_LB_GROUPS,
                          LM_SETITEMHANDLE,               /*   Message                    */
                          (MPARAM)list_index,             /*   Index of list item         */
                          (MPARAM)pGrp);                  /*   Handle of list item        */
          }

          SetColors( hwnd );
          retcode = FALSE;
          break;                                        /* WM_INITDLG                   */

        default:                                        /* Any other message            */
          retcode =  (ULONG)WinDefDlgProc(              /* Return message to default prc*/
                        hwnd,                  /* Dialog Handle                */
                        message,                        /* Message                      */
                        lParam1,                        /* First parameter for message. */
                        lParam2);                       /* Second parameter for message.*/
      }                                                 /* End switch                   */

 /***************************************************************************************
  *
  *                       Exit
  *
  ***************************************************************************************/

   return((MRESULT) retcode);
}
